﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Ewidencja zleceniobiorców</title>
		<script runat="server">

    [DefaultWidth(21)]
    public enum Zakres {
		Wszystkie, RozpoczęteUmowy, ZakończoneUmowy
    }

    public class PrnParams : ContextBase {
        public PrnParams(Context context) : base(context) {
			if (Context.Contains(typeof(OkresContext)))
				okres = ((OkresContext)Context[typeof(OkresContext)]).Okres;
		}
		    
        Zakres zakres = Zakres.Wszystkie;
        [Priority(1)]
        public Zakres Zakres {
            get { return zakres; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        FromTo okres;
        [Priority(2)]
        public FromTo Okres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        /*
        bool przedluzenia = false;
        [Priority(3)]
        [Caption("Uwzgl. przedłużenia")]
        public bool Przedluzenia {
            get { return przedluzenia; }
            set {
                przedluzenia = value;
                OnChanged(EventArgs.Empty);
            }
        }
        */
    }

    PrnParams pars;
    [Context(Required = true)]
    public PrnParams Params {
        set { pars = value; }
    }

    void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["OKRES"] = pars.Okres.ToString();
        ReportHeader1["CIAGLOSC"] = ""; //"Uwzględnione przedłużenia: " + (pars.Przedluzenia ? "TAK" : "NIE");

        switch (pars.Zakres) {
            case Zakres.RozpoczęteUmowy:
                ReportHeader1["ZAKRES"] = "Rozpoczęte umowy w okresie";
                break;
            case Zakres.ZakończoneUmowy:
                ReportHeader1["ZAKRES"] = "Zakończone umowy w okresie";
                break;
            default:
                ReportHeader1["ZAKRES"] = "Umowy w okresie";
                break;
        }
    }
	
    class UmowaComparer : IComparer<Umowa> {
        public int Compare(Umowa um1, Umowa um2) {
            return um1.Okres.CompareTo(um2.Okres);
        }
    }
    
	void Grid1_BeforeRow(Object sender, RowEventArgs args) {
		Pracownik idx = (Pracownik)args.Row;
        List<Umowa> lista = new List<Umowa>();
        
        foreach (Umowa um in idx.Umowy) {
            if (pars.Zakres == Zakres.RozpoczęteUmowy) {
                if (!pars.Okres.Contains(um.Okres.From))
                    continue;
			} else if (pars.Zakres == Zakres.ZakończoneUmowy) {
                if (!pars.Okres.Contains(um.Okres.To))
                    continue;
			} else
                if (!pars.Okres.IsIntersected(um.Okres))
					continue;
            lista.Add(um);
        }
        lista.Sort(new UmowaComparer());

        Date data = Date.MaxValue;
        bool first = true;
        bool any = false;

        foreach (Umowa um in lista) {
            //if (pars.Przedluzenia && ((um.Okres.From - data) > 1))
            //    break;
            data = um.Okres.To;
            
            if (first) {
				PracHistoria ph = idx[um.Okres.From];
                if (ph.ImieDrugie != "")
                    colImieNazw.AddLine(ph.Imie + ", " + ph.ImieDrugie);
                else
                    colImieNazw.AddLine(ph.Imie);
                colImieNazw.AddLine(ph.Nazwisko);
                colOjciecMatka.AddLine(ph.ImieOjca);
                colOjciecMatka.AddLine(ph.ImieMatki);
                colPesel.AddLine(ph.PESEL);
                colMiejsceZam.AddLine(ph.Adres.Linia1);
                colMiejsceZam.AddLine(ph.Adres.Linia2);
            }
			
			if (!first) {
				colOdUmowa.AddLine("");
                colDoUmowa.AddLine("");
			}
            colOdUmowa.AddLine(um.Okres.From);
            colOdUmowa.AddLine(um.Numer.Pelny);
			if (um.Okres.To == Date.MaxValue)
				colDoUmowa.AddLine("brak");
			else
				colDoUmowa.AddLine(um.Okres.To);
            colDoUmowa.AddLine(um.Numer.Pelny);

            first = false;
            any = true;
        }

        args.VisibleRow = any;
    }

    static void Msg(object value) {
    }
		        

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracListaSkrócona" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business" Landscape="true"></EA:DATACONTEXT>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Ewidencja zleceniobiorców|</strong>%ZAKRES%: <strong>%OKRES%|</strong>%CIAGLOSC%" runat="server"></cc1:reportheader>
			<EA:GRID id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Caption="Lp" DataMember="#" Align="Right" Width="4"></ea:GridColumn>
					<ea:GridColumn id="colImieNazw" Caption="Imiona|Nazwisko" Width="25" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colOjciecMatka" Caption="Imię ojca|Imię matki" Width="25" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colPesel" Caption="PESEL" Width="15" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colMiejsceZam" Caption="Miejsce zamieszkania" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colOdUmowa" Caption="Data początku umowy|Nr Umowy" Width="25" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colDoUmowa" Caption="Data zakończenia umowy|Nr Umowy" Width="25" NoWrap="True"></ea:GridColumn>
				</Columns>
			</EA:GRID>
			<cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
		</form>
	</body>
</HTML>
